<?php

/**
 * Unit test init file
 * @author Olek Procki <olo@velis.pl>
 */

use Velis\App;

if (!defined('PHPUNIT_INITIALIZED')) {
    define('ROOT_PATH', dirname(dirname(__DIR__)) . DIRECTORY_SEPARATOR);
    define('CONFIG_PATH', ROOT_PATH . 'config' . DIRECTORY_SEPARATOR);
    define('DATA_PATH', ROOT_PATH . 'data' . DIRECTORY_SEPARATOR);
    define('MAIL_DIR', ROOT_PATH . 'lib/Velis/Test/Mail/maildir');
    define('MODULE_PATH', ROOT_PATH . 'module' . DIRECTORY_SEPARATOR);
    define('APP_PATH', MODULE_PATH . 'Application' . DIRECTORY_SEPARATOR);

    error_reporting(E_ALL);

    set_include_path(implode(PATH_SEPARATOR, array(
        realpath(ROOT_PATH . 'lib'),
        get_include_path(),
    )));

    $_SERVER['CLI_MODE'] = true;

    $_SERVER['SERVER_NAME'] = '';
    $_SERVER['REQUEST_URI'] = '';

    if (!file_exists(ROOT_PATH . 'config/server.ini')) {
        copy(ROOT_PATH . 'config/server-dist.ini', ROOT_PATH . 'config/server.ini');
    }

    require_once 'App.php';
    require_once 'vendor/autoload.php';

    define('PHPUNIT_INITIALIZED', true);

    $app = App::init();
    $app->run();
}
