<?php

namespace Velis\User;

use Velis\Lang;
use Velis\User;

/**
 * User account notifications model
 * @author Olek Procki <olo@velis.pl>
 */
class Notification extends \Velis\Notification
{
    const REGISTRATION_CONFIRMATION = 'registration-confirmation';
    const PASSWORD_RESET            = 'password-reset';
    const CREDENTIALS_RESET         = 'credentials-reset';
    const ABSENCE_ACCEPT            = 'absence-accept';
    const ABSENCE_INFO              = 'absence-info';
    const ABSENCE_DELETED           = 'absence-deleted';
    const ACCOUNT_BLOCKED           = 'account-blocked';
    const SIGN_UP                   = 'sign-up';

    /**
     * Queue via resque
     *
     * @var int
     */
    protected static $_queueMode = self::QUEUE_RESQUE;

    /**
     * Ma wykorzystywać kolejkowanie maili
     *
     * @var bool włączone kolejkowanie maili
     */
    protected static $_queue = true;

    /**
     * Notification type
     * @var string (one of TYPE_* consts)
     */
    protected $_type;

    /**
     * No reply templates
     * @var array
     */
    protected $_noReplyTemplates = [
        self::REGISTRATION_CONFIRMATION,
        self::PASSWORD_RESET,
        self::CREDENTIALS_RESET
    ];

    /**
     * Constructor
     * @param User $user
     * @param string $type
     */
    public function __construct(User $user, $type)
    {
        $this->_type  = $type;

        parent::__construct();
        $this->user = $user;
    }


    /**
     * Returns subject for notification email
     * @return string
     */
    protected function _getMailSubject()
    {
        $subject = '';

        switch ($this->_type) {
            case self::REGISTRATION_CONFIRMATION:
                $subject = Lang::get('USER_REGISTRATION_CONFIRMATION');
                break;

            case self::PASSWORD_RESET:
                $subject = Lang::get('USER_NEW_PASS');
                break;

            case self::CREDENTIALS_RESET:
                $subject = Lang::get('NOTIFICATIONS_NEW_SYSTEM_CREDENTIALS');
                break;

            case self::ABSENCE_ACCEPT:
                $subject = Lang::get('ABSENCE_ACCEPT_REQUEST');
                break;

            case self::ABSENCE_INFO:
                $subject = Lang::get('ABSENCE_INFO_REQUEST') ;
                break;

            case self::ABSENCE_DELETED:
                $subject = Lang::get('ABSENCE_DELETED_REQUEST') ;
                break;

            case self::ACCOUNT_BLOCKED:
                $subject = Lang::get('USER_ACCOUNT_BLOCKED') ;
                break;

            case self::SIGN_UP:
                $subject = Lang::get('USER_ACCOUNT_REGISTRATION') ;
                break;
        }

        if ($this->isModified) {
                $subject .= ' [' . Lang::get('GENERAL_HISTORY_CHANGE') . ']';
        }

        return $subject;
    }


    /**
     * Sends notification
     *
     * {@inheritDoc}
     */
    public function send($sendSms = false, $files = null, $varAttachments = null)
    {
        if ($this->user->getEmail()) {
            if ($sendSms) {
                $this->addSmsRecipients(array($this->user));
            }
            return parent::send($this->user, $files, $varAttachments);
        } else {
            return false;
        }
    }
}
