<?php

namespace Velis\Throttling\LeakyBucket;

use Velis\App;

/**
* Session throttling data class
*/
class SessionStorage
{
    /**
    * Sleep time
    */
    const INTERVAL = 5;

    public function __construct()
    {
        if (!$data = App::$session->throttlingData) {
            $data = [
                'lct' =>  date('Y-m-d H:i:s'),
                'counter' => 0,
            ];
        }
        App::$session->throttlingData = $data;
    }


    /**
    * Gets value of $name variable
    */
    public function __get($name)
    {
        $data = App::$session->throttlingData;
        return $data[$name];
    }


    /**
    * Sets variable ($name) value ($value)
    */
    public function __set($name, $value)
    {
        $data =  App::$session->throttlingData;
        $data[$name] = $value;
        App::$session->throttlingData = $data;
    }


    /**
    * Returns requests interval (sleep time)
    */
    public static function getInterval()
    {
        return App::$config->actionInterval ?: self::INTERVAL;
    }


    /**
    * Returns max requests number
    */
    public static function getMaxContent()
    {
        return App::$config->maxRequests;
    }
}
