<?php

namespace Velis\Test;

use PHPUnit\Framework\TestCase;
use Velis\ZipArchive;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class ZipArchiveTest extends TestCase
{
    public function testCreateArchive()
    {
        $archive = new ZipArchive();
        $archivePath = $archive->addFromString('foo', 'bar')
            ->close();

        $this->assertTrue(file_exists($archivePath));
    }

    public function testAddFileFromString()
    {
        $archive = new ZipArchive();
        $fileName = 'test.txt';
        $contents = md5(uniqid());

        $archivePath = $archive->addFromString('test.txt', $contents)
            ->close();

        $zip = new \ZipArchive();
        $this->assertTrue($zip->open($archivePath));

        $dirPath = '/tmp/' . uniqid();
        $zip->extractTo($dirPath);
        $zip->close();

        $dirContents = scandir($dirPath);

        $this->assertTrue(in_array($fileName, $dirContents));
        $this->assertEquals($contents, file_get_contents($dirPath . '/' . $fileName));
    }
}
