<?php

namespace Velis\Test\Utility;

use Exception;
use Velis\Cache\CacheInterface;

/**
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
final class FakeCache implements CacheInterface
{
    public static array $state = [];

    public function set($key, $value, $ttl = null): void
    {
        $expiration = time() + $ttl;
        self::$state[$key] = ['value' => $value, 'expiration' => $expiration];
    }

    public function get($key, $default = null): mixed
    {
        if (!isset(self::$state[$key])) {
            return null;
        }

        $cacheItem = self::$state[$key];
        if ($cacheItem['expiration'] < time()) {
            unset(self::$state[$key]);
            return null;
        }

        return $cacheItem['value'];
    }

    public function deleteMultiple($keys)
    {
        throw new Exception('Not implemented');
    }

    public function save($key, $value, $ttl)
    {
        throw new Exception('Not implemented');
    }

    public function getProfiler(): array
    {
        throw new Exception('Not implemented');
    }

    public function delete($key)
    {
        throw new Exception('Not implemented');
    }

    public function clear()
    {
        self::$state = [];
    }

    public function exists($key): bool
    {
        throw new Exception('Not implemented');
    }

    public function flush(): bool
    {
        throw new Exception('Not implemented');
    }

    public function getKeys(string $prefix = ''): array
    {
        throw new Exception('Not implemented');
    }

    public function getMultiple($keys, $default = null)
    {
        throw new Exception('Not implemented');
    }

    public function setMultiple($values, $ttl = null)
    {
        throw new Exception('Not implemented');
    }

    public function has($key)
    {
        throw new Exception('Not implemented');
    }

    public function offsetExists(mixed $offset): bool
    {
        throw new Exception('Not implemented');
    }

    public function offsetGet(mixed $offset): mixed
    {
        throw new Exception('Not implemented');
    }

    public function offsetSet(mixed $offset, mixed $value): void
    {
        throw new Exception('Not implemented');
    }

    public function offsetUnset(mixed $offset): void
    {
        throw new Exception('Not implemented');
    }
}