<?php

namespace Velis\Test\User;

use DomainException;
use PHPUnit\Framework\TestCase;
use Velis\User;
use Velis\User\UserProvider;

class UserProviderTest extends TestCase
{
    private UserProvider $userProvider;

    protected function setUp(): void
    {
        $this->userProvider = new UserProvider();
    }

    public function testGetUserWithInvalidId(): void
    {
        $this->expectException(DomainException::class);

        $this->userProvider->getUser(0);
    }

    /**
     * @return void
     * @throws DomainException
     */
    public function testGetUser(): void
    {
        $user = $this->userProvider->getUser(1);

        self::assertInstanceOf(User::class, $user);
        self::assertEquals(1, $user->id());
    }

    /**
     * @return void
     */
    public function testGetUsers(): void
    {
        $users = $this->userProvider->getUsers([1]);

        self::assertIsArray($users);
        self::assertContainsOnlyInstancesOf(User::class, $users);
    }

    public function testGetUsersWithInvalidIds(): void
    {
        $this->expectException(DomainException::class);

        $this->userProvider->getUsers([0, 1]);
    }

    public function testCreateUser(): void
    {
        $data = [
            'user_id' => 1,
            'email' => 'test@example.org',
        ];

        $user = $this->userProvider->createUser($data);

        self::assertInstanceOf(User::class, $user);
        self::assertEquals($data['user_id'], $user->id());
        self::assertEquals($data['email'], $user->getEmail());
    }
}
