<?php

namespace Velis\Test;

use PHPUnit\Framework\TestCase;
use Velis\Textile;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class TextileTest extends TestCase
{
    /**
     * @var Textile
     */
    private $textile;

    protected function setUp(): void
    {
        $this->textile = new Textile();
    }

    /**
     * @param string $markdown
     * @param string $expectedResult
     *
     * @dataProvider provideTestDataForTextileRestrictedMethod
     */
    public function testTextileRestricted($markdown, $expectedResult)
    {
        $actualResult = $this->textile->textileRestricted($markdown);

        $this->assertEquals($expectedResult, $actualResult);
    }

    public function provideTestDataForTextileRestrictedMethod()
    {
        $bqMarkdown = <<<EOT
>quote
EOT;

        $bqHtml = <<<EOT
<blockquote>
\t<p>quote</p>
</blockquote>
EOT;

        return [
            ['Hello World!', '<p>Hello World!</p>'],
            ['< >', '<p>&lt; &gt;</p>'],
            [$bqMarkdown, $bqHtml],
        ];
    }
}
