<?php

namespace Velis\Test\Session;

use PHPUnit\Framework\TestCase;
use Velis\App;
use Velis\Session\SessionFactory;
use Velis\Session\RedisSession;
use Velis\Session\Session;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class SessionFactoryTest extends TestCase
{
    /**
     * @var SessionFactory
     */
    private SessionFactory $factory;

    protected function setUp(): void
    {
        $this->factory = new SessionFactory();
    }

    public function testCreateFileSession()
    {
        $session = $this->factory->createFileSession([]);

        static::assertInstanceOf(Session::class, $session);
    }

    public function testCreateRedisSession()
    {
        $session = $this->factory->createRedisSession([
            'host' => App::$config->session->host ?: 'redis',
            'port' => App::$config->session->port ?: 6379,
            'lifetime' => 3600,
        ]);

        static::assertInstanceOf(RedisSession::class, $session);
    }
}
