<?php

namespace Velis\Test\Session;

use AbstractSerializer;
use PHPUnit\Framework\TestCase;
use Velis\Session\Serializer\PhpSerializer;

/**
 * @author Damian Kurek <damian.kurek@velis.pl>
 */
class PhpSerializerTest extends TestCase
{
    /**
     * @var AbstractSerializer
     */
    private $serializer;

    protected function setUp(): void
    {
        $this->serializer = new PhpSerializer;
    }

    /**
     * @dataProvider provideTestDataToSerialize
     */
    public function testSerialize($toSerialize, $serializeResult)
    {
        $this->serializer->setData($toSerialize);

        $this->assertEquals(
            $serializeResult,
            $this->serializer->serialize()
        );
    }


     /**
     * @dataProvider provideTestDataToSerialize
     */
    public function testUnserialize($expected, $toUnserialize)
    {
        $this->serializer->unserialize($toUnserialize);
        $this->assertEquals(
            $expected,
           $this->serializer->getData()
        );
    }


    public function provideTestDataToSerialize()
    {
        return [
            [
                [
                    'test1' => '1111',
                    'test2' => 2
                ],
                "s:27:\"test1|s:4:\"1111\";test2|i:2;\";",
            ],
            [
                1,
                "i:1;"
            ],
            [
                [
                    'postLoginRedirect' => '/urzadzenia',
                    'redirectCalls' => 1,
                    'lastRedirectTime' => 1604917860.276606,
                    'termsOfUseAvailable' => true,
                    'csrfToken' => '821bd5d82cfee8d00b0adf8faae270b0',
                    'customTheme' => null
                ],
                "s:180:\"postLoginRedirect|s:11:\"/urzadzenia\";redirectCalls|i:1;lastRedirectTime|d:1604917860.276606;termsOfUseAvailable|b:1;csrfToken|s:32:\"821bd5d82cfee8d00b0adf8faae270b0\";customTheme|N;\";"
            ]
        ];
    }
}