<?php

namespace Velis\Test\Mvc\View\Engine;

use PHPUnit\Framework\TestCase;
use Velis\App;
use Velis\Mvc\View;
use Velis\Mvc\View\Engine\EngineFactory;
use Velis\Mvc\View\Engine\EngineInterface;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class EngineFactoryTest extends TestCase
{
    /**
     * @var EngineFactory
     */
    private $factory;

    protected function setUp(): void
    {
        $this->factory = new EngineFactory(App::$di);
    }

    public function testCreateEngine()
    {
        $viewMock = $this->createMock(View::class);
        $engine = $this->factory->createEngine($viewMock);

        $this->assertInstanceOf(EngineInterface::class, $engine);
    }
}
