<?php

namespace Velis\Test\Mvc\Controller\Utils;

use PHPUnit\Framework\TestCase;
use Velis\Mvc\Controller\Utils\RouteClassifier;

/**
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
final class RouteClassifierTest extends TestCase
{
    /**
     * @dataProvider provideDataForTestIsPublic
     */
    public function testIsPublic(string $controllerClass, string $actionName, bool $expectedResult): void
    {
        $result = RouteClassifier::isPublic($controllerClass, $actionName);

        $this->assertTrue($result === $expectedResult);
    }

    /**
     * @return array{string, string, bool}[]
     */
    public function provideDataForTestIsPublic(): array
    {
        return [
            [FakeController::class, 'my-test-public', true],
            [FakeController::class, 'my-test-protected', false],
            [FakeController::class, 'not-existing-route', false],
            ['Not\\Existing\\Controller', 'not-existing-route', false],
        ];
    }
}
