<?php

namespace Test\Model\DataObject;

use PHPUnit\Framework\TestCase;
use Velis\Bpm\Person;
use Velis\Bpm\Ticket\Post;
use Velis\Bpm\Ticket\Ticket;
use Velis\Model\DataObject;

class CollectionTraitTest extends TestCase
{
    /**
     * @param string $class
     * @param array $collection
     * @param array $expectedIds
     *
     * @dataProvider provideTestDataForGetCollectionIdsMethod
     */
    public function testGetCollectionIds(string $class, array $collection, array $expectedIds)
    {
        $actualIds = $class::getCollectionIds($collection);

        $this->assertEquals($expectedIds, $actualIds);
    }

    public function provideTestDataForGetCollectionIdsMethod()
    {
        return [
            [
                Ticket::class,
                [
                    new Ticket([
                        'ticket_id' => 25,
                    ]),
                ],
                [25],
            ],
            [
                Ticket::class,
                [
                    new Post([
                        'ticket_post_id' => 200,
                        'ticket_id' => 15,
                    ]),
                ],
                [15],
            ],
            [
                Ticket::class,
                [
                    [
                        'ticket_post_id' => 200,
                        'ticket_id' => 15,
                    ],
                ],
                [15],
            ],
            [
                Post::class,
                [
                    new Ticket([
                        'ticket_id' => 50,
                    ])
                ],
                [],
            ],
        ];
    }

    /**
     * @param DataObject $object
     * @return void
     * @dataProvider provideTestDataForGetDataStoreItemMethod
     */
    public function testGetDataStoreItem(DataObject $object)
    {
        $item = $object->getDataStoreItem();

        $this->assertIsArray($item);
        $this->assertNotEmpty($item);
    }

    public function provideTestDataForGetDataStoreItemMethod()
    {
        return [
            [new Person(['first_name' => 'Jan', 'last_name' => 'Kowalski'])],
            [new Ticket(['ticket_id' => 123456])],
        ];
    }
}