<?php

namespace Model\DataObject;

use Company\Partner;
use PHPUnit\Framework\TestCase;
use Velis\Bpm\Resource;

class CacheTraitFunctionalTest extends TestCase
{
    public function testAddingEntryClearsCache()
    {
        Resource::listCached();

        $resource = new Resource([
            'name' => 'Resource ' . uniqid(),
        ]);

        $resource->add(true);
        $resourceId = $resource->id();

        $resourceFromCache = Resource::get($resourceId);
        $this->assertInstanceOf(Resource::class, $resourceFromCache);
    }

    public function testSavingEntryRefreshesList()
    {
        Partner::listCached();

        $partner = new Partner([
            'name' => 'Partner ' . uniqid(),
        ]);
        $partner->save(true);

        $this->assertArrayHasKey($partner->id(), Partner::listCached(), implode(', ', array_keys(Partner::listCached())));
    }
}
