<?php

namespace Velis\Test\Mail;

use Psr\SimpleCache\InvalidArgumentException;
use Velis\App;
use Velis\App\Config;
use Velis\Arrays;
use Velis\Bpm\Email\Account;
use Velis\Mail\AccountFactory;
use PHPUnit\Framework\TestCase;
use Velis\Model\DataObject\NoColumnsException;
use Velis\Notification\Log;

/**
 * @author Damian Kurek <damian.kurek@velistech.com>
 */
class AccountFactoryTest extends TestCase
{
    /**
     * @param $config
     * @param $account
     * @param $log
     * @param $expected
     * @return void
     * @throws InvalidArgumentException
     * @throws NoColumnsException
     * @dataProvider provideTestDataForGetAccountMethod
     */
    public function testGetAccount($config, $account, $log, $expected)
    {
        $factory = new AccountFactory(new Config($config), $account, $log);
        self::assertEquals($expected, $factory->getAccount());
    }


    public function provideTestDataForGetAccountMethod()
    {
        $defaultConfig = Arrays::toArray(App::$config->notifications);
        unset($defaultConfig['smtpBackupServer']);

        $defaultAccount = new Account([
            'email_address' => $defaultConfig['emailFrom'],
            'sender_label' => $defaultConfig['nameFrom'],
            'outgoing_auth' => $defaultConfig['smtpAuth'] ?? 'login',
            'login' => $defaultConfig['smtpUser'],
            'password' => $defaultConfig['smtpPassword'],
            'client_id' => $defaultConfig['smtpClientId'],
            'client_secret' => $defaultConfig['smtpClientSecret'] ?? $defaultConfig['smtpPassword'],
            'outgoing_server' => $defaultConfig['smtpServer'],
            'outgoing_port' => $defaultConfig['smtpPort'],
            'outgoing_ssl' => $defaultConfig['smtpSsl'],
        ]);

        $logBelowThreshold = new Log([
            'unsuccessful_attempts' => AccountFactory::BACKUP_ACCOUNT_THRESHOLD,
        ]);


        $configWithBackupServer = $defaultConfig;
        $configWithBackupServer['smtpBackupServer'] = 'mail-bck.velistech.com';


        $logExceededLimit = new Log([
            'unsuccessful_attempts' => AccountFactory::BACKUP_ACCOUNT_THRESHOLD + 1,
        ]);

        $backupAccount = clone $defaultAccount;
        $backupAccount->outgoing_server = $configWithBackupServer['smtpBackupServer'];


        $account = new Account([
            'email_address' => 'test@velis.pl',
            'sender_label' => 'Velis',
            'outgoing_auth' => 'login',
            'login' => 'login',
            'password' => 'password',
            'outgoing_server' => 'smtp_server',
            'outgoing_port' => 422,
            'outgoing_ssl' => 1,
        ]);

        $predefinedAccountResult = clone $account;


        $configAlwaysUseBackup = $configWithBackupServer;
        $configAlwaysUseBackup['alwaysUseBackupServer'] = 1;

        return [
            [$defaultConfig, null, $logBelowThreshold, $defaultAccount],
            [$configWithBackupServer, null, $logBelowThreshold, $defaultAccount],
            [$configWithBackupServer, null, $logExceededLimit, $backupAccount],
            [$configWithBackupServer, $account, $logBelowThreshold, $predefinedAccountResult],
            [$configAlwaysUseBackup, $account, $logBelowThreshold, $backupAccount],
            [$configWithBackupServer, $account, $logExceededLimit, $backupAccount],
            [$defaultConfig, $account, $logExceededLimit, $predefinedAccountResult],
            [$defaultConfig, null, $logExceededLimit, $defaultAccount],
        ];
    }
}
