<?php

namespace Velis\Test\Lang;

use Velis\App;
use Velis\Lang\LangVariant\OverloadedLang;

class LangVariantsFixture
{
    public const VARIANT = "TEST";
    public const VARIANT2 = "TEST2";

    public function fillCache(): void
    {
        App::$cache['lang_variant_cache_' . static::VARIANT] = [
            new OverloadedLang(
                'BUILDING',
                'COMPLEX',
                'COMPLEX_TEST'
            ),
            new OverloadedLang(
                'GENERAL',
                'ADD',
                'ADD_TEST',
            ),
        ];

        App::$cache['lang_variant_cache_' . static::VARIANT2] = [
            new OverloadedLang(
                'BUILDING',
                'COMPLEX',
                'COMPLEX_TEST2'
            ),
            new OverloadedLang(
                'GENERAL',
                'ADD',
                'ADD_TEST2',
            ),
        ];
    }
}
