<?php

namespace Velis\Test\Lang;

use PHPUnit\Framework\TestCase;
use Velis\Lang\LangVariant;

class LangVariantTest extends TestCase
{
    protected function setUp(): void
    {
        $fixture = new LangVariantsFixture();
        $fixture->fillCache();
    }

    /**
     * @param string $acro
     * @param string $key
     * @param bool $expected
     * @return void
     * @dataProvider provideDataForHasVariantAcronym
     */
    public function testHasVariantAcronym(string $acro, string $key, bool $expected)
    {
        $variant = new LangVariant($acro);
        $this->assertEquals($expected, $variant->hasVariantAcronym($key));
    }

    public function provideDataForHasVariantAcronym()
    {
        return [
            [LangVariantsFixture::VARIANT, 'BUILDING_COMPLEX', true],
            [LangVariantsFixture::VARIANT, 'GENERAL_ADD', true],
            [LangVariantsFixture::VARIANT, 'BUILDING_COMPLEXES', false],
            [LangVariantsFixture::VARIANT2, 'BUILDING_COMPLEX', true],
            [LangVariantsFixture::VARIANT2, 'GENERAL_ADD', true],
            [LangVariantsFixture::VARIANT2, 'BUILDING_COMPLEXES', false],
            ['OTHER', 'BUILDING_COMPLEX', false],
        ];
    }

    /**
     * @param string $acro
     * @param string $key
     * @param bool $isOverloaded
     * @return void
     * @dataProvider provideDataForHasVariantAcronym
     */
    public function testGetAcronymForVariant(string $acro, string $key, bool $isOverloaded)
    {
        $variant = new LangVariant($acro);
        $newKey = $key;

        if ($isOverloaded) {
            $newKey .= '_' . $acro;
        }

        $this->assertEquals($newKey, $variant->getAcronymForVariant($key));
    }

    /**
     * @param string $acro
     * @return void
     * @dataProvider provideDataForGetOverloadedLangs
     */
    public function testGetOverloadedLangsMap(string $acro)
    {
        $variant = new LangVariant($acro);

        foreach ($variant->getOverloadedLangsMap() as $key => $item) {
            $this->assertEquals($key . '_' . $acro, $item);
        }
    }

    public function provideDataForGetOverloadedLangs()
    {
        return [
            [LangVariantsFixture::VARIANT],
            [LangVariantsFixture::VARIANT2],
        ];
    }
}
