<?php

namespace Lang\LangVariant;

use PHPUnit\Framework\TestCase;
use Velis\Lang\LangVariant;
use Velis\Lang\LangVariant\LangVariantProvider;
use Velis\Lang\LangVariant\OverloadedLangProvider;

class OverloadedLangProviderTest extends TestCase
{
    public function testGetOverloadedLangs(): void
    {
        $langVariant = $this->createMock(LangVariant::class);
        $langVariant->expects($this->once())
            ->method('getOverloadedLangsMap')
            ->willReturn([
                'KEY1' => 'KEY1_OVERLOADED',
                'KEY2' => 'KEY2_OVERLOADED',
            ]);

        $langVariantProvider = $this->createMock(LangVariantProvider::class);
        $langVariantProvider->expects($this->once())
            ->method('getLangVariant')
            ->willReturn($langVariant);

        $overloadedLangs = [
            'KEY2' => 'KEY2_OVERLOADED_AGAIN',
            'KEY3' => 'KEY3_OVERLOADED',
        ];

        $provider = new OverloadedLangProvider($langVariantProvider, $overloadedLangs);
        $actualOverloadedLangs = $provider->getOverloadedLangs();

        $expectedOverloadedLangs = [
            'KEY1' => 'KEY1_OVERLOADED',
            'KEY2' => 'KEY2_OVERLOADED_AGAIN',
            'KEY3' => 'KEY3_OVERLOADED',
        ];

        $this->assertEquals($expectedOverloadedLangs, $actualOverloadedLangs);
    }
}
