<?php

namespace Velis\Test\Filesystem\Stream;

use PHPUnit\Framework\TestCase;
use Velis\Filesystem\Stream\LocalStream;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class LocalStreamTest extends TestCase
{
    const FILENAME = 'test.txt';

    /**
     * @var LocalStream
     */
    private $stream;

    /**
     * {@inheritDoc}
     */
    protected function setUp(): void
    {
        file_put_contents(__DIR__ . self::FILENAME, '1234567890');

        $this->stream = new LocalStream(__DIR__ . self::FILENAME);
    }

    public function testOpen()
    {
        $this->assertTrue($this->stream->open());

        $invalidStream = new LocalStream(__DIR__ . 'invalid.txt');
        $this->assertFalse($invalidStream->open());
    }

    public function testSeek()
    {
        $this->assertFalse($this->stream->seek(0, SEEK_SET));

        $this->stream->open();
        $this->assertTrue($this->stream->seek(0, SEEK_SET));
    }

    public function testRead()
    {
        $this->assertFalse($this->stream->read(5));

        $this->stream->open();
        $this->assertEquals('12345', $this->stream->read(5));
        $this->assertEquals('67890', $this->stream->read(5));
        $this->assertEquals('', $this->stream->read(5));
    }

    /**
     * {@inheritDoc}
     */
    protected function tearDown(): void
    {
        unlink(__DIR__ . self::FILENAME);
    }
}
