<?php

namespace Velis\Test\Dto\Validators;

use PHPUnit\Framework\TestCase;
use Velis\Dto\Validators\ArrayOf;

class ArrayOfTest extends TestCase
{
    /**
     * @dataProvider provideTestData
     */
    public function testValidate(string $type, bool $notEmpty, mixed $value, bool $expectedResult): void
    {
        $validator = new ArrayOf($type, $notEmpty);
        $actualResult = $validator->validate($value);

        $this->assertEquals($expectedResult, $actualResult);
    }

    public function provideTestData(): array
    {
        return [
            [ArrayOf::TYPE_INT, false, 1, false],
            [ArrayOf::TYPE_INT, false, 's', false],
            [ArrayOf::TYPE_INT, false, [], true],
            [ArrayOf::TYPE_INT, true, [], false],
            [ArrayOf::TYPE_INT, false, ['a', 'b', 'c'], false],
            [ArrayOf::TYPE_INT, false, [1.2, 2.5], false],
            [ArrayOf::TYPE_INT, false, [true, false], false],
            [ArrayOf::TYPE_INT, false, ['a', 1, 3.14, false], false],
            [ArrayOf::TYPE_INT, false, [1, 2, 3], true],
            [ArrayOf::TYPE_INT, false, ['1', '2', '3'], true],
            [ArrayOf::TYPE_FLOAT, false, ['a', 'b', 'c'], false],
            [ArrayOf::TYPE_FLOAT, false, [true, false], false],
            [ArrayOf::TYPE_FLOAT, false, [1, 2, 3], false],
            [ArrayOf::TYPE_FLOAT, false, ['a', 1, 3.14, false], false],
            [ArrayOf::TYPE_FLOAT, false, [1.2, 2.5], true],
            [ArrayOf::TYPE_FLOAT, false, ['1.2', '2.5'], true],
            [ArrayOf::TYPE_STRING, false, [true, false], false],
            [ArrayOf::TYPE_STRING, false, [1, 2, 3], false],
            [ArrayOf::TYPE_STRING, false, [1.2, 2.5], false],
            [ArrayOf::TYPE_STRING, false, ['a', 1, 3.14, false], false],
            [ArrayOf::TYPE_STRING, false, ['a', 'b', 'c'], true],
            [ArrayOf::TYPE_BOOL, false, [1, 2, 3], false],
            [ArrayOf::TYPE_BOOL, false, [1.2, 2.5], false],
            [ArrayOf::TYPE_BOOL, false, ['a', 'b', 'c'], false],
            [ArrayOf::TYPE_BOOL, false, ['a', 1, 3.14, false], false],
            [ArrayOf::TYPE_BOOL, false, [true, false], true],
        ];
    }
}
