<?php

namespace Velis\Test\Dto\Validators;

use Velis\Dto\Validators\ArrayLengthRange;
use Velis\TestCase;

class ArrayLengthRangeTest extends TestCase
{
    /**
     * @dataProvider provideTestData
     */
    public function testValidate(?int $min, ?int $max, $value, bool $expectedResult): void
    {
        $validator = new ArrayLengthRange($min, $max);
        $actualResult = $validator->validate($value);

        $this->assertEquals($expectedResult, $actualResult);
    }

    /**
     * @return array<array{0: ?int, 1: ?int, 2: mixed, 3: bool}>
     */
    public function provideTestData(): array
    {
        return [
            [1, 10, 'abc', false],
            [1, 10, [1], true],
            [1, 10, [], false],
            [null, 1, [1, 2], false],
            [null, 1, [], true],
            [null, 1, [1], true],
            [2, 5, [1], false],
            [2, 5, [1, 2], true],
            [2, null, [1], false],
            [2, null, [1, 2], true],
        ];
    }
}
