<?php

namespace Velis\Test\Dto\Concrete\Validators;

use Attribute;
use Velis\Dto\Validators\BaseValidator;

#[Attribute]
class MaxLength extends BaseValidator
{
    public function __construct(
        public ?int $max = null,
        public string $message = 'Invalid length'
    ) {
    }

    public function validate($value): bool
    {
        if (!is_string($value)) {
            return false;
        }

        if ($this->max !== null && strlen($value) > $this->max) {
            $this->message = 'Value is too long';

            return false;
        }

        return true;
    }
}
