<?php

namespace Velis\Test\Db;

use PHPUnit\Framework\TestCase;
use Velis\App;
use Velis\Db\SqlScriptParser;

class SqlScriptParserTest extends TestCase
{
    /**
     * @param string $sql
     * @param array $params
     * @param string $expected
     * @dataProvider provideTestDataForParseMethod
     * @return void
     */
    public function testParse(string $sql, array $params, string $expected)
    {
        $parser = new SqlScriptParser();
        $result = $parser->parse($sql, $params);
        self::assertEquals($expected, $result);
    }


    public function provideTestDataForParseMethod()
    {
        $db = App::getService('db');
        $params = [
            'test_id' => [
                1,
                2,
                3,
            ],
            'field' => 'test',
        ];


        $params2 = [
            'param' => [
                "asda'12",
                "123sd",
                "asdasd",
            ],
            'field' => '1.23',
        ];

        return [
            [
                'SELECT * FROM app.test WHERE 1=1' . $db->conditions($params),
                $params,
                "SELECT * FROM app.test WHERE 1=1 AND (test_id IN( 1, 2, 3)) AND field = 'test'"
            ],
            [
                'SELECT * FROM app.test WHERE 1=1' . $db->conditions($params2),
                $params2,
                "SELECT * FROM app.test WHERE 1=1 AND (param IN( 'asda''12', '123sd', 'asdasd')) AND field = 1.23"],
        ];
    }
}
