<?php

namespace Velis\Test\Db;

use PHPUnit\Framework\TestCase;
use Velis\Db\ClassMetadata;
use Velis\Db\EntityRepository;
use Velis\QuickReport\Category;
use Velis\Repository\QuickReport\CategoryRepository;
use Velis\Timezone;
use Velis\User;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class ClassMetadataTest extends TestCase
{
    /**
     * @param string $entityClass
     * @param string $expectedResult
     *
     * @dataProvider provideTestDataForGetTableNameMethod
     */
    public function testGetTableName(string $entityClass, string $expectedResult)
    {
        $classMetadata = new ClassMetadata($entityClass);
        $actualResult = $classMetadata->getTableName();

        $this->assertEquals($expectedResult, $actualResult);
    }

    public function provideTestDataForGetTableNameMethod()
    {
        return [
            [User::class, 'acl.user_tab'],
        ];
    }

    /**
     * @param string $entityClass
     * @param string $expectedResult
     *
     * @dataProvider provideTestDataForGetPrimaryKeyFieldMethod
     */
    public function testGetPrimaryKeyField(string $entityClass, string $expectedResult)
    {
        $classMetadata = new ClassMetadata($entityClass);
        $actualResult = $classMetadata->getPrimaryKeyField();

        $this->assertEquals($expectedResult, $actualResult);
    }

    public function provideTestDataForGetPrimaryKeyFieldMethod()
    {
        return [
            [User::class, 'user_id'],
        ];
    }

    /**
     * @param string $entityClass
     * @param string $expectedResult
     *
     * @dataProvider provideTestDataForGetRepositoryClassMethod
     */
    public function testGetRepositoryClass(string $entityClass, string $expectedResult)
    {
        $classMetadata = new ClassMetadata($entityClass);
        $actualResult = $classMetadata->getRepositoryClass();

        $this->assertEquals($expectedResult, $actualResult);
    }

    public function provideTestDataForGetRepositoryClassMethod()
    {
        return [
            ['User\User', 'User\Repository\UserRepository'],
            ['Cia\Category', EntityRepository::class],
            [Category::class, CategoryRepository::class],
            [Timezone::class, EntityRepository::class],
        ];
    }
}
