<?php

namespace Velis\Test\Cache;

use PHPUnit\Framework\TestCase;
use Velis\Cache\CacheFactory;
use Velis\Cache\FileCache;
use Velis\Cache\RedisCache;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class CacheFactoryTest extends TestCase
{
    /**
     * @var CacheFactory
     */
    private $factory;

    protected function setUp(): void
    {
        $this->factory = new CacheFactory();
    }

    public function testCreateFileCache()
    {
        $cache = $this->factory->createFileCache([]);

        $this->assertInstanceOf(FileCache::class, $cache);
    }

    public function testCreateRedisCache()
    {
        $cache = $this->factory->createRedisCache([]);

        $this->assertInstanceOf(RedisCache::class, $cache);
    }
}
