<?php

namespace Velis\Test\Cache;

use PHPUnit\Framework\TestCase;
use Velis\App;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class AbstractCacheFunctionalTest extends TestCase
{
    protected function setUp(): void
    {
        App::$cache->clear();
    }

    public function test()
    {
        $key = 'key1';

        $this->assertFalse(App::$cache->has($key));
        $this->assertNull(App::$cache->get($key));

        $value = 'value1';

        App::$cache->set($key, $value);

        $this->assertTrue(App::$cache->has($key));
        $this->assertEquals($value, App::$cache->get($key));

        App::$cache->delete($key);

        $this->assertFalse(App::$cache->has($key));
    }

    public function testArrayAccess()
    {
        $key = 'key2';

        $this->assertFalse(isset(App::$cache[$key]));
        $this->assertNull(App::$cache[$key]);

        $value = 'value2';

        App::$cache[$key] = $value;

        $this->assertTrue(isset(App::$cache[$key]));
        $this->assertEquals($value, App::$cache[$key]);

        unset(App::$cache[$key]);

        $this->assertFalse(isset(App::$cache[$key]));
    }

    protected function tearDown(): void
    {
        App::$cache->clear();
    }
}
