<?php

namespace Velis\Test\Bpm\Ticket\Mixin;

use PHPUnit\Framework\TestCase;
use Velis\App;
use Velis\Bpm\Ticket\Log;
use Velis\Bpm\Ticket\Mixin\HistoryTrait;
use Velis\Bpm\Ticket\Ticket;
use Velis\Db\Db;
use Velis\Model\DataObject\NoColumnsException;

class HistoryTraitTest extends TestCase
{
    /**
     * @param HistoryTrait $ticket
     * @return void
     * @dataProvider provideTestData
     */
    public function testGetFirstLog($ticket)
    {
        $log = $ticket->getFirstLog();

        $this->assertInstanceOf(Log::class, $log);
        $this->assertEquals($ticket, $log->getTicket());
    }

    /**
     * @return Ticket[][]
     * @throws NoColumnsException
     */
    public function provideTestData()
    {
        /** @var Db $db */
        $db = App::$di['db'];
        $query = 'SELECT * FROM app.ticket ORDER BY ticket_id DESC LIMIT 5';
        $tickets = $db->getAll($query);

        return array_map(function (array $row) {
            return [new Ticket($row)];
        }, $tickets);
    }
}