<?php

namespace Velis\Test\Bpm\Email;

use PHPUnit\Framework\TestCase;
use Velis\Arrays;
use Velis\Bpm\Email\Account;
use Velis\Bpm\Email\Message;
use Zend\Mail\Storage\Message as StorageMessage;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class MessageTest extends TestCase
{
    public function testGetAttachments()
    {
        $params = ['file' => MAIL_DIR . '/new/07-duplicated-or-empty-attachments.eml'];
        $data = new StorageMessage($params);

        $account = Arrays::getFirst(Account::getList(1, null, null, 1));
        $message = new Message($data, $account);
        $message->add();

        $attachments = $message->getAttachments();

        $this->assertEquals(6, count($attachments));

        foreach ($attachments as $attachment) {
            $this->assertNotEmpty($attachment->getContents());
        }

        $message->remove();
    }
}
