<?php

namespace Velis\Test\Auth;

use InvalidArgumentException;
use PHPUnit\Framework\TestCase;
use Velis\Auth\FilterFactory;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class FilterFactoryTest extends TestCase
{
    /**
     * @var FilterFactory
     */
    private $factory;

    protected function setUp(): void
    {
        $this->factory = new FilterFactory();
    }

    public function provideAdapter()
    {
        return [
            [FilterFactory::ADAPTER_OPENSSL],
        ];
    }

    /**
     * @param $adapter
     *
     * @dataProvider provideAdapter
     */
    public function testCreateDecryptionFilter($adapter)
    {
        $filter = $this->factory->createDecryptionFilter($adapter);

        $this->assertEquals($adapter, $filter->getAdapter());
    }

    public function testCreateDecryptionFilterWithInvalidAdapter()
    {
        $this->expectException(InvalidArgumentException::class);

        $this->factory->createDecryptionFilter('invalid');
    }
}
