<?php

namespace Velis\Test\App;

use PHPUnit\Framework\TestCase;
use Velis\App;
use Velis\App\Config;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class ConfigTest extends TestCase
{
    public function testGetReturnsVelisAppConfigInstance()
    {
        $data = App::$config->settings;

        $this->assertInstanceOf(Config::class, $data);
    }

    public function testSet()
    {
        $value = 'bar';
        App::$config->settings->foo = $value;

        $this->assertEquals($value, App::$config->settings->foo);
        $this->assertEquals($value, App::$config->settings->get('foo'));
    }
}
