<?php

namespace Velis\Test;

use Velis\Acl;
use Velis\App;
use Velis\Exception;
use Velis\TestCase;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class AclTest extends TestCase
{
    /**
     * @return void
     * @throws Exception
     */
    public function testTmpPasswordWithStrongOption()
    {
        App::$config->settings->strongPassword = 1;

        for ($i = 0; $i < 5; $i++) {
            $password = Acl::tmpPassword();

            static::assertMatchesRegularExpression('/[a-z]/', $password);
            static::assertMatchesRegularExpression('/[A-Z]/', $password);
            static::assertMatchesRegularExpression('/[0-9]/', $password);
            static::assertMatchesRegularExpression('/[!\$_\-\/\.,]/', $password);
        }
    }
}
