<?php

namespace Velis\Session;

/**
 * Interface of session factory classes
 *
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface SessionFactoryInterface
{
    /**
     * Creates file-based session
     *
     * @param array $config
     * @return SessionInterface
     */
    public function createFileSession(array $config): SessionInterface;

    /**
     * Creates Redis session
     *
     * @param array $config
     * @return SessionInterface
     */
    public function createRedisSession(array $config): SessionInterface;
}
