<?php

namespace Velis\Session\Adapter;

use Phalcon\Session\Adapter\Redis as BaseAdapter;
use Phalcon\Storage\AdapterFactory;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class Phalcon4RedisAdapter extends BaseAdapter
{
    /**
     * Overridden constructor - original constructor does not allow setting prefix option
     * @param AdapterFactory $factory
     * @param array $options
     */
    public function __construct(AdapterFactory $factory, array $options = array())
    {
        $this->adapter = $factory->newInstance('redis', $options);
    }

    /**
     * Get prefix
     * @return string
     */
    public function getPrefix()
    {
        return $this->adapter->getPrefix();
    }
}
