<?php

namespace Velis\Repository;

use Velis\Arrays;
use Velis\Db\EntityRepository;

/**
 * @author Jakub Szczugieł <jakub.szczugiel@velistech.com>
 */
class UserRepository extends EntityRepository
{
    public function getIdsByRoles($roles)
    {
        if (!$roles) {
            return [];
        }

        $params = [
            'role_id' => $roles
        ];

        $query = "SELECT user_id FROM acl.user_role_tab WHERE 1=1 ";
        $query .= $this->db->conditions($params);

        return Arrays::getColumn($this->db->getAll($query, $params), 'user_id');
    }
}
