<?php

namespace Velis\Repository\Lang;

use Velis\Db\EntityRepository;
use Velis\Lang\Value;

/**
 * @extends EntityRepository<Value>
 */
class ValueRepository extends EntityRepository
{
    protected function getConditions(array $criteria, array &$parameters): array
    {
        $conditions = [];

        if (array_key_exists('lang_key', $criteria) && !empty($criteria['lang_key'])) {
            $langKeys = [];
            $i = 0;
            foreach ($criteria['lang_key'] as $langKey) {
                $parameterName = 'lang_key_' . $i;
                $langKeys[] = ":$parameterName";
                $parameters[$parameterName] = $langKey;
                $i++;
            }

            $langKeysStr = implode(',', $langKeys);

            $conditions[] = "lang_group_id || '_' || lang_key_id IN ($langKeysStr)";

            unset($criteria['lang_key']);
        }

        if (array_key_exists('search', $criteria)) {
            $search = $criteria['search'];
            $conditions[] = 'value ILIKE :search';
            $parameters['search'] = "%$search%";
            unset($criteria['search']);
        }

        return array_merge($conditions, parent::getConditions($criteria, $parameters));
    }
}
