<?php

namespace Velis\Repository;

use Psr\SimpleCache\InvalidArgumentException;
use ReflectionException;
use Velis\CronJob;
use Velis\CronLog;
use Velis\Db\EntityRepository;

/**
 * @author Jan Małysiak <jan.malysiak@velistech.com>
 */
class CronLogRepository extends EntityRepository
{
    /**
     * @return CronLog[]
     * @throws InvalidArgumentException
     * @throws ReflectionException
     */
    public function findUnfinishedTasks(): array
    {
        $tasks = $this->db->getAll("
            SELECT * FROM app.cron_log_tab
            WHERE status = :status AND date_started < now() - interval '4 hours'
        ", [
            'status' => CronJob::STATUS_STARTED,
        ]);

        return $this->hydrateObjects($tasks);
    }
}
