<?php

namespace Velis\Redis;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface RedisClientInterface
{
    /**
     * @param string $host
     * @param int $port
     * @return bool
     */
    public function connect(string $host, int $port = 6379): bool;

    /**
     * @param string $channel
     * @param string $message
     * @return int Number of clients that received the message
     */
    public function publish(string $channel, string $message): int;
}
