<?php

namespace Velis\Queue;

/**
 * Interface QueueInterface
 *
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface QueueInterface
{
    /**
     * Sets backend connection parameters
     * @param string $server
     */
    public function setBackend($server);

    /**
     * Add task to the queue
     * @param string $queue
     * @param string $class
     * @param array|null $args
     * @return string|boolean
     */
    public function enqueue($queue, $class, $args = null);

    /**
     * Creates new instance of worker
     * @param $queues
     * @return WorkerInterface
     */
    public function createWorker($queues);
}
