<?php

namespace Velis\Queue;

use Resque;
use Resque_Failure;
use Resque_Worker;
use Velis\Redis\Failure;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class Queue implements QueueInterface
{
    /**
     * {@inheritDoc}
     */
    public function setBackend($server)
    {
        Resque_Failure::setBackend(Failure::class);
        Resque::setBackend($server);
    }

    /**
     * {@inheritDoc}
     */
    public function enqueue($queue, $class, $args = null)
    {
        Resque_Failure::setBackend(Failure::class);
        return Resque::enqueue($queue, $class, $args);
    }

    /**
     * {@inheritDoc}
     */
    public function createWorker($queues)
    {
        $wrapped = new Resque_Worker($queues);

        return new Worker($wrapped);
    }
}
