<?php

namespace Velis\Queue;

/**
 * Interface of queue jobs
 *
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface JobInterface
{
    /**
     * Add job to the queue
     *
     * @param QueueInterface $queue
     */
    public function addToQueue(QueueInterface $queue): void;

    /**
     * Called before performing job
     */
    public function setUp(): void;

    /**
     * Perform actual job
     */
    public function perform(): void;

    /**
     * Called after finishing job
     */
    public function tearDown(): void;
}
