<?php

namespace Velis\Pdf;

use iio\libmergepdf\Driver\TcpdiDriver;
use iio\libmergepdf\Merger as BaseMerger;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class Merger
{
    public function __construct()
    {
        $this->wrapped = new BaseMerger(new TcpdiDriver());
    }

    /**
     * @param RenderableInterface $document
     * @return void
     */
    public function appendDocument(RenderableInterface $document)
    {
        $rawString = $document->render();
        $this->wrapped->addRaw($rawString);
    }

    /**
     * @return string
     */
    public function renderMergedDocument(): string
    {
        return $this->wrapped->merge();
    }
}
