<?php

namespace Velis;

class ParametersParser
{
    public function parse(array $params): Filter
    {
        $arguments = [];

        foreach ($params as $k => $arg) {
            if (strpos($arg, '=')) {
                list($argName, $argValue) = explode('=', $arg);
                $arguments[$argName] = $argValue;
            } elseif (Filter::startsWith($arg, '--')) {
                $arguments[lcfirst(Output::toPascalCase(trim($arg, '--')))] = true;
            } elseif ($k == 3) {
                $arguments[lcfirst(Output::toPascalCase($params[2]))] = $arg;
            } else {
                $arguments[$k] = $arg;
            }
        }

        return new Filter($arguments);
    }
}
