<?php

namespace Velis\Paginator\Adapter;

use Laminas\Paginator\Adapter\ArrayAdapter as BaseArrayAdapter;

/**
 * Paginator adapter
 * @author Olek Procki <olo@velis.pl>
 */
class ArrayAdapter extends BaseArrayAdapter
{
    /**
     * Constructor.
     *
     * @param array $array Array to paginate
     * @param int $total total number of rows (usually returned from FOUND_ROWS() MySQL function)
     */
    public function __construct(array $array, $total = null)
    {
        $this->array = $array;
        if ($total != null) {
            $this->count = $total;
        } else {
            $this->count = count($array);
        }
    }
}
