<?php

namespace Velis\Notification;

use Velis\App;
use Velis\Model\DataObject;
use Velis\Exception as VelisException;
use Exception;

/**
 * Mobile notification log model
 * @author Damian Kurek <damian.kurek@velistech.com>
 */
class MobileLog extends DataObject
{
    /**
     * {@inheritdoc}
     */
    protected function _getTableName()
    {
        return 'app.mobile_notification_log_tab';
    }


    /**
     * Creates new log
     * @param array $message
     */
    public static function log(array $message)
    {
        if (!App::$config->fcm->log) {
            return;
        }

        try {
            preg_match('/\d+$/', $message['topic'], $matches);
            $log = new static([
                'topic' => $message['topic'],
                'user_id' => $matches[0],
                'title' => $message['notification']['title'],
                'body' => $message['notification']['body']
            ]);
            $log->add();
        } catch (Exception $e) {
            throw new VelisException($e->getMessage(), $e->getCode(), $e);
        }
    }
}
