<?php

namespace Velis\Notification;

use Velis\Model\DataObject;
use Velis\Model\Cacheable;

/**
 * Description of Method
 *
 * @author tomek
 */
class Method extends DataObject implements Cacheable
{

    protected static $_listDefaultOrder = 'name';

    /**
     * Returns related sql table
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.notification_method_tab';
    }


     /**
     * Returns role name
     * @return string
     */
    public function getName()
    {
        return $this->getTranslatedName();
    }
}
