<?php

namespace Velis\Notification\ContentModifier;

/**
 * Strip tags notification content modifier
 * @author Damian Kurek <damian.kurek@velis.pl>
 */
class StripTagsModifier implements ContentModifierInterface
{
    /**
     * Strips HTML and PHP tags
     * @param string $content
     * @param array $params
     * @return string
     */
    public function __invoke($content, $params = [])
    {
        return strip_tags($content);
    }
}
