<?php

namespace Velis\Notification\ContentModifier;

use Velis\Output;

/**
 * Strip polish chars notification content modifier
 * @author Damian Kurek <damian.kurek@velis.pl>
 */
class StripPolishCharsModifier implements ContentModifierInterface
{
    /**
     * Strips polish chars
     * @param string $content
     * @param array $params
     * @return string
     */
    public function __invoke($content, $params = [])
    {
        return Output::stripPolishChars(trim($content));
    }
}
