<?php

namespace Velis\Notification;

use Velis\Model\File as FileModel;
use Velis\Model\Sanitizable as Sanitizable;
use Velis\App;
use Velis\Lang;
use RuntimeException;
use Exception;

/**
 * Notification attachment file
 *
 * @author Robert Jamróz <robert.jamroz@velis.pl>
 */
class Attachment extends FileModel implements Sanitizable
{

    protected static $_filterListParams = true;


    /**
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.notification_attachment_tab';
    }


    /**
     * Just insert new row to database
     * @return \Velis\Notification\Attachment
     */
    public function insert()
    {
        return parent::add(true);
    }


    /**
     * Removes dabatase row
     * @return bool
     */
    public function remove()
    {
        $return = null;

        try {
            $commit = self::$_db->startTrans();
            self::$_db->execDML(
                'DELETE FROM app.notification_log_attachment_tab
                 WHERE notification_attachment_id = :notification_attachment_id',
                array(
                    'notification_attachment_id' => $this->id()
                 )
            );
            $return = parent::_remove();
            if ($commit) {
                self::$_db->commit();
            }
        } catch (Exception $e) {
            if ($commit) {
                self::$_db->rollback();
            }
        }

        return $return;
    }


    /**
     * Returns file download path
     * @return string
     */
    public function getDownloadUrl()
    {
    }


    /**
     * @return string
     */
    public static function getStorageDirPath()
    {
        return 'file/notification-attachment' . DIRECTORY_SEPARATOR;
    }


    /**
     * Returns storage directory
     * @return string
     */
    protected function _getStorageDir()
    {
        return self::_getPrefixForStorageDir() . self::getStorageDirPath();
    }


    /**
     * Returns storage directory
     * @return string
     */
    public function getStorageDir()
    {
        return $this->_getStorageDir();
    }


    /**
     * Returns file path
     * @return string
     */
    public function getStorageFilename()
    {
        return $this->_getStorageFilename();
    }


    /**
     * Inserts relation log row
     *
     * @param \Velis\Notification\Log|int $log
     * @param int $fileId
     */
    public function insertRelation($log)
    {
        self::$_db->insert(
            'app.notification_log_attachment_tab',
            array(
                'notification_log_id' => $log instanceof Log ? $log->id() : $log,
                'notification_attachment_id' => $this->id()
            )
        );
    }


    /**
     * Returns attachement list
     *
     * @param int $page
     * @param array|ArrayObject $params
     * @param string $order
     * @param int $limit
     * @param string|array $fields
     *
     * @return \Velis\Notification\Attachment[]
     */
    public static function getList($page = 1, $params = null, $order = null, $limit = self::ITEMS_PER_PAGE, $fields = null)
    {
        if ($params['notification_log_id']) {
            self::$_listConditions[] = 'EXISTS(
                SELECT 1 FROM app.notification_log_attachment_tab nla
                WHERE notification_log_id = :notification_log_id
                  AND notification_attachment_id = app.notification_attachment_tab.notification_attachment_id
            )';
            self::$_listParams['notification_log_id'] = $params['notification_log_id'];
            unset($params['notification_log_id']);
        }

        return parent::getList($page, $params, $order, $limit, $fields);
    }
}
