<?php

namespace Velis;

use Velis\Model\DataObject;

/**
 * News model
 * @author Krzysztof Frydrych <krzysztof.frydrych@velis.pl>
 */
class News extends DataObject
{
    /**
     * companies list
     * @var array
     */
    protected $_companies;

    /**
     * Returns related table name
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.news_tab';
    }


    /**
     * Returns news title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this['title'];
    }


    /**
     * Returns news title
     *
     * @return string
     */
    public function getContent()
    {
        return $this['content'];
    }


    /**
     * Returns news expiry date
     *
     * @return string
     */
    public function getDateExpiry()
    {
        return $this['date_expiry'];
    }


    /**
     * {@inheritDoc}
     */
    public static function listAll($params = null, $order = null, $fields = null)
    {
        if ($params instanceof Filter) {
            $params = $params->getArrayCopy();
        }

        if (!$params['show_expired']) {
            self::$_listConditions[] = 'COALESCE(date_expiry, NOW()) >= NOW()';
        }
        unset($params['show_expired']);

        return parent::listAll($params, 'news_id DESC');
    }


    /**
     * Saves news
     *
     * @param bool $updateObjectId
     * @return News
     */
    public function add($updateObjectId = false)
    {
        $this['added_user_id'] = App::getUserId();
        return parent::add($updateObjectId);
    }


    /**
     * Removes news and any existing role-based restrictions
     *
     */
    public function remove()
    {
        self::$_db->startTrans();

       // $this->removeCompany();
        parent::_remove();

        self::$_db->commit();
    }
}
