<?php

namespace Velis\Mvc\View\Helper;

use Velis\Output;

/**
 * Layout box helper
 * @author Olek Procki <olo@velis.pl>
 */
class Box
{
    /**
     * Returns script include HTML
     * @return string
     */
    public function __invoke($module, $box)
    {
        $boxClass = Output::toPascalCase($module) . '\Box\\' . Output::toPascalCase($box);

        if (class_exists($boxClass)) {
            $box = new $boxClass();
            return $box();
        }
    }
}
