<?php

namespace Velis\Mvc\View\Helper;

use Velis\App;
use Velis\Db\SqlScriptParser;
use Velis\Debug;
use Velis\Lang;

/**
 * base class for debug profilers
 * @author Valerii Shaparev <sadzeburo@gmail.com>
 */
abstract class BaseProfiler
{
    /**
     * True if already rendered
     * @var bool
     */
    protected static $_rendered = false;


    /**
     * HTML output
     * @var string|array
     */
    protected $_output = '';


    /**
     * Is standalone ouside of layout?
     * @var bool
     */
    protected $_standalone = false;

    /**
     * @var SqlScriptParser
     */
    protected $sqlScriptParser;

    public function __construct(bool $standalone = false)
    {
        $this->sqlScriptParser = new SqlScriptParser();
        $this->_standalone = $standalone;
    }

    /**
     * get data of the profiler
     *
     * @return void|string|array
     */
    abstract public function getProfiler();

    protected function buildProfiler(): void
    {
        $this->buildDbProfiler();

        if (App::$config->snowflake) {
            $this->buildDbProfiler('snowflake');
        }

        $this->buildCacheProfiler();

        if (!$this->_standalone) {
            $this
                ->buildMissingLangs()
                ->buildIncludesList()
                ->buildPrivsList()
                ->buildServerVars();
        }
    }

    protected function getMissingLanguagesDataProvider(): array
    {
        return Lang::getMissingTranslations();
    }

    protected function getPrivsDataProvider(): array
    {
        return App::$di->get('privsLogger')->all();
    }

    protected function getCacheDataProvider(): array
    {
        return App::$cache->getProfiler();
    }

    protected function getDbDataProvider(string $dbName): array
    {
        /** @var \Velis\Db\Profiler $dbProfiler */
        $dbProfiler = App::$di[$dbName]->getProfiler();

        return $dbProfiler->flushAllRows();
    }

    protected function getIncludesListKey(): string
    {
        return 'included files (' . count(get_included_files()) . ')';
    }

    /** @return String[] */
    protected function getIncludesListDataProvider()
    {
        return get_included_files();
    }
}
